<?php

include_once 'conexao.php';
  
class ModeloQuestionario
{   
	static public function mdlAddQuestionario($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO quetionario
						(pergunta, idTema, idRecrutador, dataCadastro,idVaga,ordem,resposta) VALUES (:pergunta, :idTema, :idRecrutador, :dataCadastro,:idVaga,:ordem,:resposta)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":pergunta", $dados["pergunta"], PDO::PARAM_STR);
		$stmt->bindParam(":idTema", $dados["idTema"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":ordem", $dados["ordem"], PDO::PARAM_STR);
		$stmt->bindParam(":idRecrutador", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":resposta", $dados["resposta"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	} 

	static public function mdlMostrarTodasAsPerguntasDoQuestionarioPoridVaga($idVaga,$idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM quetionario where idVaga = :idVaga and idTema = :idTema order by idQuetionario");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}  
 
	static public function mdlMostrarTodasAsPerguntasDoQuestionarioPoridVagaEIdTema($idVaga, $idTema) { 

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM quetionario where idVaga = :idVaga and idTema = :idTema order by idQuetionario");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}  

	static public function mdlMostrarEOrdenarPerguntasPorNumeroDeOrdemTodasAsPerguntasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	static public function mdlMostrarEOrdenarPerguntasTodasPerguntasDaAvaliacaoPorIdVagaEIdTema($idVaga,$idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idExercicioTema = '$idTema' order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	static public function mdlVerificarPerguntaJaEstaNoQuestionarioPoridVagaEPreguntaEIdTema($idVaga,$pergunta, $idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM quetionario where idTema = :idTema and idVaga = :idVaga and pergunta = :pergunta order by idQuetionario");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":pergunta", $pergunta, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	} 
 
	static public function mdlMostrarPerguntaPorIdPergunta($idPergunta) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idPergunta = :idPergunta");
			$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarPerguntaPoridVagaENumeroDeOrdem($idVaga,$ordem) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and ordem = :ordem");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":ordem", $ordem, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarPerguntaDaAvaliacaoPoridVagaENumeroDeOrdemEIdTema($idVaga,$ordem,$idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and ordem = :ordem and idExercicioTema = :idTema");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":ordem", $ordem, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	

	static public function mdlEditarPergintaPorIdPergunta($idPergunta, $ordem,$pergunta){
 
		$stmt = Conexao::conectar()->prepare("UPDATE pergunta SET ordem = :ordem, pergunta = :pergunta where idPergunta = :idPergunta ");
		$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
		$stmt->bindParam(":ordem", $ordem, PDO::PARAM_STR);
		$stmt->bindParam(":pergunta", $pergunta, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}
 
	static public function mdlEliminarPerguntaPorIdPergunta($id){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM pergunta where idPergunta = :id ");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>